/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xlnk;

import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import uk.co.demon.obelisk.xapp.Application;
import uk.co.demon.obelisk.xapp.Option;
import uk.co.demon.obelisk.xlnk.Area;
import uk.co.demon.obelisk.xlnk.BinTarget;
import uk.co.demon.obelisk.xlnk.HexTarget;
import uk.co.demon.obelisk.xlnk.S19Target;
import uk.co.demon.obelisk.xlnk.Target;
import uk.co.demon.obelisk.xobj.BinaryExpr;
import uk.co.demon.obelisk.xobj.Byte;
import uk.co.demon.obelisk.xobj.Code;
import uk.co.demon.obelisk.xobj.Evaluatable;
import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Extern;
import uk.co.demon.obelisk.xobj.Hex;
import uk.co.demon.obelisk.xobj.Library;
import uk.co.demon.obelisk.xobj.Long;
import uk.co.demon.obelisk.xobj.Module;
import uk.co.demon.obelisk.xobj.Parser;
import uk.co.demon.obelisk.xobj.Part;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.SectionMap;
import uk.co.demon.obelisk.xobj.SymbolMap;
import uk.co.demon.obelisk.xobj.UnaryExpr;
import uk.co.demon.obelisk.xobj.Word;

public abstract class Linker
extends Application {
    private final int byteSize;
    private final long byteMask;
    private Option code = new Option("-code", "Code region(s)", "<regions>");
    private Option data = new Option("-data", "Data region(s)", "<regions>");
    private Option bss = new Option("-bss", "BSS region(s)", "<regions>");
    private Option hex = new Option("-hex", "Generate HEX output");
    private Option bin = new Option("-bin", "Generate binary output");
    private Option s19 = new Option("-s19", "Generate Motorola S19 output");
    private Option output = new Option("-output", "Output file", "<file>");
    private Vector<Module> modules = new Vector();
    private Vector<Library> libraries = new Vector();
    private Hashtable<String, Module> refs = new Hashtable();
    private Hashtable<String, Module> defs = new Hashtable();
    private Vector<Section> abs = new Vector();
    private Vector<Section> rel = new Vector();
    private Hashtable<String, Area> areas = new Hashtable();
    private SectionMap sectionMap = new SectionMap();
    private SymbolMap symbolMap = new SymbolMap();
    private Target target;
    private int errors = 0;

    protected Linker(int byteSize) {
        this.byteSize = byteSize;
        this.byteMask = (1L << byteSize) - 1L;
    }

    protected void startUp() {
        super.startUp();
        this.createAreas();
        if (!(this.hex.isPresent() || this.bin.isPresent() || this.s19.isPresent())) {
            this.error("No output format selected (-bin, -hex or -s19).");
            this.setFinished(true);
            return;
        }
        if (this.hex.isPresent() && this.bin.isPresent() || this.bin.isPresent() && this.s19.isPresent() || this.s19.isPresent() && this.hex.isPresent()) {
            this.error("Only one output format can be selected at a time.");
            this.setFinished(true);
        } else {
            long hi = 0L;
            long lo = 0xFFFFFFFFL;
            Area area = this.areas.get(".code");
            if (area != null) {
                if (area.getHiAddr() > hi) {
                    hi = area.getHiAddr();
                }
                if (area.getLoAddr() < lo) {
                    lo = area.getLoAddr();
                }
            }
            if ((area = this.areas.get(".data")) != null) {
                if (area.getHiAddr() > hi) {
                    hi = area.getHiAddr();
                }
                if (area.getLoAddr() < lo) {
                    lo = area.getLoAddr();
                }
            }
            if (this.hex.isPresent()) {
                this.target = new HexTarget(lo, hi, this.byteSize);
            } else if (this.bin.isPresent()) {
                this.target = new BinTarget(lo, hi, this.byteSize);
            } else if (this.s19.isPresent()) {
                this.target = new S19Target(lo, hi, this.getAddrSize(), this.byteSize);
            }
        }
        if (this.getArguments().length == 0) {
            System.err.println("Error: No object or library files specified");
            this.setFinished(true);
        }
    }

    protected void execute() {
        File mapFile;
        File objectFile;
        Section section;
        int index;
        int moduleCount;
        String[] arguments = this.getArguments();
        int index2 = 0;
        while (index2 < arguments.length) {
            Object object;
            if (arguments[index2].endsWith(".obj")) {
                object = Parser.parse(arguments[index2]);
                if (object != null && object instanceof Module) {
                    if (!this.modules.contains(object)) {
                        this.modules.add((Module)object);
                    } else {
                        this.warning("Module '" + arguments[index2] + "' specified more than once");
                    }
                } else {
                    this.error("Invalid object file '" + arguments[index2] + "'");
                    this.setFinished(true);
                }
            } else if (arguments[index2].endsWith(".lib")) {
                object = Parser.parse(arguments[index2]);
                if (object != null && object instanceof Library) {
                    if (!this.libraries.contains(object)) {
                        this.libraries.add((Library)object);
                    } else {
                        this.warning("Library '" + arguments[index2] + "' specified more than once");
                    }
                } else {
                    this.error("Invalid library file '" + arguments[index2] + "'");
                    this.setFinished(true);
                }
            } else {
                this.error("Unrecognized file type for '" + arguments[index2] + "'");
                this.setFinished(true);
            }
            ++index2;
        }
        if (this.isFinished()) {
            return;
        }
        index2 = 0;
        while (index2 < this.modules.size()) {
            this.processModule(this.modules.elementAt(index2));
            ++index2;
        }
        do {
            moduleCount = this.modules.size();
            index = 0;
            while (index < this.libraries.size()) {
                this.processLibrary(this.libraries.elementAt(index));
                ++index;
            }
        } while (this.modules.size() != moduleCount);
        if (this.refs.size() > 0) {
            Enumeration<String> cursor = this.refs.keys();
            while (cursor.hasMoreElements()) {
                String key = cursor.nextElement();
                Module module = this.refs.get(key);
                this.error("Undefined symbol: " + key + " in " + module.getName());
            }
            this.setFinished(true);
            return;
        }
        index = 0;
        while (index < this.modules.size()) {
            Vector<Section> sections = this.modules.elementAt(index).getSections();
            int count = 0;
            while (count < sections.size()) {
                Section section2 = sections.elementAt(count);
                Vector<Section> vec = section2.isAbsolute() ? this.abs : this.rel;
                boolean handled = false;
                int position = 0;
                while (position < vec.size()) {
                    Section other = vec.elementAt(position);
                    if (other.getSize() < section2.getSize()) {
                        vec.insertElementAt(section2, position);
                        handled = true;
                        break;
                    }
                    ++position;
                }
                if (!handled) {
                    vec.add(section2);
                }
                ++count;
            }
            ++index;
        }
        index = 0;
        while (index < this.abs.size()) {
            section = this.abs.elementAt(index);
            long base = this.fitSection(section);
            if (base == -1L) {
                return;
            }
            this.sectionMap.setBaseAddress(section, base);
            ++index;
        }
        index = 0;
        while (index < this.rel.size()) {
            section = this.rel.elementAt(index);
            long base = this.fitSection(section);
            if (base == -1L) {
                return;
            }
            this.sectionMap.setBaseAddress(section, base);
            ++index;
        }
        index = 0;
        while (index < this.modules.size()) {
            Module module = this.modules.elementAt(index);
            Vector<String> globals = module.getGlobals();
            int count = 0;
            while (count < globals.size()) {
                String symbol = globals.elementAt(count);
                Expr expr = module.getGlobal(symbol);
                this.symbolMap.addAddress(symbol, expr.resolve(this.sectionMap, this.symbolMap));
                ++count;
            }
            ++index;
        }
        index = 0;
        while (index < this.modules.size()) {
            this.fixUp(this.modules.elementAt(index));
            ++index;
        }
        if (this.output.isPresent()) {
            String filename = this.output.getValue();
            objectFile = new File(filename);
            mapFile = new File(String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + ".map");
        } else {
            String filename = this.getArguments()[0];
            objectFile = this.hex.isPresent() ? new File(String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + ".hex") : new File(String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + ".bin");
            mapFile = new File(String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + ".map");
        }
        this.writeMap(mapFile);
        this.target.writeTo(objectFile);
        this.setFinished(true);
    }

    protected void cleanUp() {
        if (this.errors > 0) {
            System.exit(1);
        }
    }

    protected String describeArguments() {
        return " <object/library file> ...";
    }

    protected void error(String message) {
        System.err.print("Error: ");
        System.err.println(message);
        ++this.errors;
    }

    protected void warning(String message) {
        System.err.print("Warn: ");
        System.err.println(message);
    }

    protected void createAreas() {
        if (this.code.getValue() != null && this.code.getValue().contains("-")) {
            this.addArea(".code", this.code.getValue());
        }
        if (this.data.getValue() != null && this.data.getValue().contains("-")) {
            this.addArea(".data", this.data.getValue());
        }
        if (this.bss.getValue() != null && this.bss.getValue().contains("-")) {
            this.addArea(".bss", this.bss.getValue());
        }
        if (!this.areas.containsKey(".data")) {
            this.areas.put(".data", this.areas.get(".code"));
        }
    }

    protected final void addArea(String name, String location) {
        Area area = new Area(location);
        this.areas.put(name, area);
    }

    protected abstract int getAddrSize();

    private void processModule(Module module) {
        Vector<Section> sections = module.getSections();
        int index = 0;
        while (index < sections.size()) {
            Section section = sections.elementAt(index);
            Vector<Part> parts = section.getParts();
            int count = 0;
            while (count < parts.size()) {
                Part part = parts.elementAt(count);
                if (part instanceof Evaluatable) {
                    this.processExpression(((Evaluatable)((Object)part)).getExpr(), module);
                }
                ++count;
            }
            ++index;
        }
        Vector<String> globals = module.getGlobals();
        int index2 = 0;
        while (index2 < globals.size()) {
            String symbol = globals.elementAt(index2);
            if (!this.defs.containsKey(symbol)) {
                this.defs.put(symbol, module);
                this.refs.remove(symbol);
            } else {
                this.error("Redefinition of symbol '" + symbol + "' in module '" + module.getName() + "'");
                this.setFinished(true);
            }
            ++index2;
        }
    }

    private void processLibrary(Library library) {
        Module[] modules = library.getModules();
        int count = 0;
        while (count < modules.length) {
            Module module = modules[count];
            Vector<String> globals = module.getGlobals();
            int index = 0;
            while (index < globals.size()) {
                String symbol = globals.elementAt(index);
                if (this.refs.containsKey(symbol)) {
                    this.modules.add(module);
                    this.processModule(module);
                    break;
                }
                ++index;
            }
            ++count;
        }
    }

    private void processExpression(Expr expr, Module module) {
        if (expr instanceof Extern) {
            String name = ((Extern)expr).getName();
            if (!this.refs.containsKey(name)) {
                this.refs.put(name, module);
            }
        } else if (expr instanceof UnaryExpr) {
            this.processExpression(((UnaryExpr)expr).getExp(), module);
        } else if (expr instanceof BinaryExpr) {
            this.processExpression(((BinaryExpr)expr).getLhs(), module);
            this.processExpression(((BinaryExpr)expr).getRhs(), module);
        }
    }

    private long fitSection(Section section) {
        Area area = this.areas.get(section.getName());
        if (area == null) {
            this.error("No memory area has been allocated for " + section.getName());
            this.setFinished(true);
            return -1L;
        }
        return area.fitSection(section);
    }

    private void fixUp(Module module) {
        Vector<Section> sections = module.getSections();
        int index = 0;
        while (index < sections.size()) {
            Section section = sections.elementAt(index);
            Vector<Part> parts = section.getParts();
            long addr = this.sectionMap.baseAddressOf(section);
            int count = 0;
            while (count < parts.size()) {
                Part part = parts.elementAt(count);
                if (part instanceof Code) {
                    String value = part.toString();
                    int span = module.getByteSize() / 4;
                    int digit = 0;
                    while (digit < value.length()) {
                        this.target.store(addr, Integer.parseInt(value.substring(digit, digit + span), 16));
                        ++addr;
                        digit += span;
                    }
                } else if (part instanceof Evaluatable) {
                    Expr expr = ((Evaluatable)((Object)part)).getExpr();
                    long value = expr.resolve(this.sectionMap, this.symbolMap);
                    if (part instanceof Byte) {
                        this.target.store(addr, value);
                        ++addr;
                    } else if (part instanceof Word) {
                        this.storeWord(addr, value, module.isBigEndian());
                        addr += 2L;
                    } else if (part instanceof Long) {
                        this.storeLong(addr, value, module.isBigEndian());
                        addr += 3L;
                    }
                }
                ++count;
            }
            ++index;
        }
    }

    private void storeWord(long addr, long value, boolean bigEndian) {
        if (bigEndian) {
            this.target.store(addr + 0L, value >> 1 * this.byteSize & this.byteMask);
            this.target.store(addr + 1L, value >> 0 * this.byteSize & this.byteMask);
        } else {
            this.target.store(addr + 1L, value >> 1 * this.byteSize & this.byteMask);
            this.target.store(addr + 0L, value >> 0 * this.byteSize & this.byteMask);
        }
    }

    private void storeLong(long addr, long value, boolean bigEndian) {
        if (bigEndian) {
            this.target.store(addr + 0L, value >> 3 * this.byteSize & this.byteMask);
            this.target.store(addr + 1L, value >> 2 * this.byteSize & this.byteMask);
            this.target.store(addr + 2L, value >> 1 * this.byteSize & this.byteMask);
            this.target.store(addr + 3L, value >> 0 * this.byteSize & this.byteMask);
        } else {
            this.target.store(addr + 3L, value >> 3 * this.byteSize & this.byteMask);
            this.target.store(addr + 2L, value >> 2 * this.byteSize & this.byteMask);
            this.target.store(addr + 1L, value >> 1 * this.byteSize & this.byteMask);
            this.target.store(addr + 0L, value >> 0 * this.byteSize & this.byteMask);
        }
    }

    private void writeMap(File file) {
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.println("Symbol Map\n");
            Object[] symbols = this.symbolMap.getSymbols().toArray();
            Arrays.sort(symbols);
            int index = 0;
            while (index < symbols.length) {
                String symbol = (String)symbols[index];
                writer.println(String.valueOf(symbol) + "  " + Hex.toHex(this.symbolMap.addressOf(symbol), 8));
                ++index;
            }
            writer.close();
        }
        catch (Exception error) {
            System.err.println("Error: A serious error occurred while writing the map file");
        }
    }
}

